<?php
$ds_meta_boxes = array(
  "media" => array("name" => "media","id" => "media","std" => "","title" => "Media","description" => "Optional image of the offer/product (URL<br/>must start with http://)."),
  "url" => array("name" => "url","id" => "url","std" => "","title" => "Conversion URL","description" => "This creates the call-to-action button (URL must start with http://)."),
  "salecaption" => array("name" => "salecaption","id" => "salecaption","std" => "","title" => "Sales Caption","description" => "H3/H4 subtitle/caption beneath post<br/>headline."),
  "buttonwidth" => array("name" => "buttonwidth","id" => "buttonwidth","std" => "","title" => "Button Width","description" => "Optional value which allows to changes to the width of the button. Example value would be \"250px\".")
);
function ds_meta_boxes() {
  global $post, $ds_meta_boxes;
  foreach($ds_meta_boxes as $meta_box) {
    $meta_box_value = get_post_meta($post->ID, $meta_box['name'].'_value', true);
    if($meta_box_value == "") $meta_box_value = $meta_box['std'];
    echo'
      <div class="post-meta-box">
        <input type="hidden" name="'.$meta_box['name'].'_noncename" id="'.$meta_box['name'].'_noncename" value="'.wp_create_nonce( plugin_basename(__FILE__) ).'" />
        <h4>'.$meta_box['title'].'</h4>
        <input type="text" name="'.$meta_box['name'].'_value" value="'.$meta_box_value.'" size="55" />
        <p><label for="'.$meta_box['name'].'_value">'.$meta_box['description'].'</label>  [<a target="blank" href="http://www.affiliatetheme.net/members/resource-center/tutorials/custom-fields/">?</a>]</p>
        
        
      </div>
      
    ';
  }
}
function ds_create_box() {
  global $theme_name;
  if ( function_exists('add_meta_box') ) {
    add_meta_box( 'ds-meta-boxes', 'Affiliate Theme Custom Fields', 'ds_meta_boxes', 'post', 'normal', 'high' );
  }
}
function ds_save_data( $post_id ) {
  global $post, $ds_meta_boxes;
  foreach($ds_meta_boxes as $meta_box) {
    if ( !wp_verify_nonce( $_POST[$meta_box['name'].'_noncename'], plugin_basename(__FILE__) )) { return $post_id; }
    if ( 'page' == $_POST['post_type'] ) {
      if ( !current_user_can( 'edit_page', $post_id )) return $post_id;
    } else {
      if ( !current_user_can( 'edit_post', $post_id )) return $post_id;
    }
    $data = $_POST[$meta_box['name'].'_value'];
    if(get_post_meta($post_id, $meta_box['name'].'_value') == "") add_post_meta($post_id, $meta_box['name'].'_value', $data, true);
    elseif($data != get_post_meta($post_id, $meta_box['name'].'_value', true)) update_post_meta($post_id, $meta_box['name'].'_value', $data);
    elseif($data == "") delete_post_meta($post_id, $meta_box['name'].'_value', get_post_meta($post_id, $meta_box['name'].'_value', true));
  }
}
add_action('admin_menu', 'ds_create_box');
add_action('save_post', 'ds_save_data');
?>